/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile'
	, 'hbs!applets/wound-care-applet/templates/newSkinInspection'
	, 'hbs!applets/wound-care-applet/templates/empty'
	,	'applets/wound-care-applet/util'],
	function ( Backbone, Marionette, $, _, jqm, template, emptyTemplate, util) {
		'use strict';
		var $colorCom,
			$colorComReq,
			$probCom,
			$probComReq,
			commentReq = '<span class="required">*</span> Please write a comment',
			rfNeed = '<span class="required">*</span> Please make one or more selections from below',
			$rfMore,
			that,
			shouldColor,
			shouldProblem,
			$savePopup,
			$ulcerPopup,
			input= {
				'assessment':'allAreasAssessed',
				'skin-patches':'skinPatches',
				'risk-factors-yn':'riskFactors',
				'risk-factors':'riskFactorSelections',
				'skin-color':'skinColor',
				'skin-temperature':'skinTemperature' ,
				'skin-moisture':'skinMoisture',
				'skin-turgor':'skinTurgor' ,
				'skin-problem':'skinProblems' ,
				'ulcer':'ulcerPresent'
			};
				return Backbone.Marionette.ItemView.extend({
				className: "applet scrollable new-inspection",
				id:'wound-care',
				template : template,
				events : {
					'change :checkbox':'clearChecks',
					'click #clear' : 'clearAll',
					'change #ulcer-group :radio' : 'ulcerSelect',
					//'change #skin-color-2d' : 'otherColor',
//					'change #skin-problem-2c' : 'otherProblem',
					'click #save-skin-assessment' : 'saveAssessmentEvent',

					'change #color-group2 input': 'clearCommentReq',// input:not(#skin-color-2d)
					'change #skin-color-comment' :'colorCommentFilled',
					'change #skin-problem-comment' :'problemCommentFilled',
					'change input, textarea' : 'anyInputChanged',
					'autosave': "autosaveEvent",
					'write-to-note': 'writteToNoteEvent',
					'change input#ulcer-yes': "showUlcerYesMsg"

				},
					initialize:function(options){
						that = this;
						that.vent = options.vent || new Backbone.Wreqr.EventAggregator();
						this.listenTo(this, "write-to-note", that.writteToNoteEvent );
						that.listenTo(that.vent, 'note-writer-close', that.enableView  );
						that.listenTo(that.vent, 'note-writer-open', that.disableView );
						// TODO: Oh my
						if( $("#clinic-event.ui-panel-open").length === 1  )
						{
							that.disableView();
						}
					},
					disableView:function(){
						console.log("disable forms");
						this.template = emptyTemplate;
						this.render();this.onShow();
					},
					enableView:function(){
						console.log("ebable forms");
						this.template = template;
						this.render();this.onShow();
					},
					onShow: function () {

//						that.$el.find('input#ulcer-yes').bind("change", function(){
//							console.log("whut whit");
//						});//that.showUlcerYesMsg );

						shouldColor = shouldProblem = false;
						$('#applet-title h2').html('Skin Assessment');
						$rfMore = this.$el.find('#risk-factors-more');
						$colorCom = this.$el.find('#skin-color-comment');
						$colorComReq = this.$el.find('#skin-color-comment-req');
						$probCom = this.$el.find('#skin-problem-comment');
						$probComReq = this.$el.find('#skin-problem-comment-req');
						this.infoTip();
						this.autosavePull();
//						if (this.model.get('skinInspection').status === 'WRITTEN_TO_NOTE') {
//							this.$el.find('input').prop('disabled',true);
//							this.$el.find('textarea').prop('disabled',true);
//							this.$el.find('button').prop('disabled',true);
//						}
						if (this.model.get('skinInspection').status !== 'WRITTEN_TO_NOTE') {
							that.riskFactorToggle($(':checked[name="risk-factors-yn"]').val());
						}
						this.$el.trigger('create');
						this.vent.trigger("show");
//						this.$el.attr('style', Portal.scrollableZoneHeight() );
						$ulcerPopup = $('#ulcer-popup');
						this.setupPopup();
						$ulcerPopup.on('popupafteropen',function() {$ulcerPopup.find('[data-icon="delete"]').focus();});
					},
					showUlcerYesMsg:function(e){
						that.$el.find(".ulcer-yes-msg").show();
					},
					setupPopup: function () {
						$savePopup = $('<div data-role="popup" id="risk-factor-saved-popup" data-inline="true" data-overlay-theme="a" class="wc-popup"><a href="#" data-rel="back" data-role="button" data-theme="a" data-icon="delete" data-iconpos="notext" class="ui-btn-right">Close popup</a><p class="wc-subtitle">Assessment Saved</p></div>');

						$savePopup.on('popupafteropen',function() {
							$savePopup.find('[data-icon="delete"]').focus();
						});
						$savePopup.on('popupafterclose',function() {
							$savePopup.remove();
							that.setupPopup();
						});
					},
				anyInputChanged: function(e) {
					var target = $(e.currentTarget),
						name = target.attr('name'),
						id = target.attr('id'),
						notOnComment=true;
					if (id.indexOf('comment') !== -1) {
						name = id.substring(0, id.indexOf('-comment'));
						notOnComment = false;
					}
					if (name === 'skin-problem') {
						if (!this.commentCheck($probCom,shouldProblem))
							this.$el.find('#' + name + '-req').html('');
					}
					else if (name === 'skin-color'){
						if (!this.commentCheck($colorCom,shouldColor))
							this.$el.find('#' + name + '-req').html('');
					}
					else if (name === 'risk-factors-yn') {
						this.riskFactorToggle(target.val());
					}
					else if (name === 'risk-factors') {
						if ($(':checked[name="risk-factors"]').length > 0){
							$rfMore.html('');
							this.$el.find('#' + name + '-req').html('');
						}
						else if ($(':checked[name="risk-factors-yn"]').val()==='Yes')
							$rfMore.html(rfNeed);		
					}
					else if (notOnComment)
						this.$el.find('#' + name + '-req').html('');
				},
				riskFactorToggle: function(val) {
					var $checked = $(':checked[name="risk-factors"]'),
						$ynBtn = $('[name="risk-factors"]');
					$ynBtn.checkboxradio();
					if (val === 'Yes') {
						if ($checked.length === 0)
							$rfMore.html(rfNeed);
						$ynBtn.prop('disabled',false).checkboxradio('enable');

					}
					else {
						$rfMore.html('');
						this.$el.find('#' + 'risk-factors' + '-req').html('');
						$ynBtn.prop('disabled',true).checkboxradio('disable');
						_.each($checked, function(t) {
							$(t).checkboxradio();
							$(t).prop('checked', false).checkboxradio('refresh');
						});
					}
				},
				colorCommentFilled: function(e) {
					if (this.commentCheck($(e.currentTarget),shouldColor)) {
						shouldColor = true;
						$colorComReq.html(commentReq);
					}
					else {
						$colorComReq.html('');
					}
				},
				problemCommentFilled: function(e) {
					var truth = this.commentCheck($(e.currentTarget),shouldProblem);
					if (truth) {
						shouldProblem = true;
						$probComReq.html(commentReq);
					}
					else
						$probComReq.html('');

				},
				commentCheck:function(target,should){
					if (target.val() === '' && should)
						return true;
					else
						return false;
				},
				clearCommentReq: function(e) {
					console.log($(e.currentTarget).attr('id'));
					if ($(e.currentTarget).attr('id') === 'skin-color-2d') {

						if ($colorCom.val() === '' && $colorComReq.html() === '') {
							$colorComReq.html(commentReq);
							shouldColor = true;
						}
					}
					else if ($colorComReq.html() === commentReq) {
						$colorComReq.html('');
						shouldColor = false;
					}
					else
						shouldColor = false;
				},
//				otherProblem: function(e) {
//
//					if ($probCom.val() === '' && $probComReq.html() === '') {
//						$probComReq.html(commentReq);
//						shouldProblem = true;
//					}
//					else if ($probComReq.html() === commentReq) {
//						$probComReq.html('');
//						shouldProblem = false;
//					}
//					else
//						shouldProblem = false;
//
//				},
//				otherColor: function(e) {
//
//					if ($colorCom.val() === '') {
//						$colorComReq.html(commentReq);
//						shouldColor = false;
//					}
//				},
				clearChecks: function(e) {
                    var none = $('#skin-problem-1a');
					if (e.currentTarget.id !== none.attr('id'))
						none.prop('checked', false).checkboxradio('refresh');
					else {
						if ($probComReq.html() === commentReq)
							$probComReq.html('');
						_.each($(':checkbox'), function(t) {
							$(t).prop('checked', false).checkboxradio('refresh');
						});
						none.prop('checked', true).checkboxradio('refresh');
					}
				},
				savePopup: function() {
					that.$el.append($savePopup);
					$savePopup.trigger('create');
					$savePopup.popup();
					$savePopup.popup('open');
				},
				ulcerSelect: function(e) {
                    var target = $(e.currentTarget);
					if (target.attr('id') === 'ulcer-yes')
						$('#' + target.attr('data-rel')).popup('open',{transition:'pop',inline:'true'});
				},
				clearAll:function() {
					_.each($(':radio'), function(t) {
						$(t).prop('checked', false).checkboxradio('refresh');
					});
					_.each($(':checkbox'), function(t) {
						$(t).prop('checked', false).checkboxradio('refresh');
					});
					_.each($('textarea'), function(t) {
						$(t).val('');
					});
					_.each(this.$el.find('[id$=-comment]'), function(e) {
						e.innerHTML = '';
					});
					_.each(input, function(put){
						that.$el.find('#'+put+'-req').html('');
					});

				},
				infoTip: function() {
					util.infoTip();
				},
				onClose: function (){
					$savePopup.off('popupafteropen');
					$savePopup.off('popupafterclose');
					$ulcerPopup.off('popupafteropen');
					$ulcerPopup.popup('destroy');
				},
				writteToNoteEvent:function(){
					if( that.model.get('skinInspection').status === 'WRITTEN_TO_NOTE' ){
						that.$el.find("input[type='radio'], input[type='checkbox']").checkboxradio('disable');
						that.$el.find('textarea').textinput('disable');
						that.$el.find('button').button("disable");
						that.$el.find("input[type=number]").slider('disable');
					}
				},
				disableInputs: function(){
					if (that.model.get('skinInspection').status === 'WRITTEN_TO_NOTE') {
						that.$el.find("input[type='radio'], input[type='checkbox']").checkboxradio('disable');
						that.$el.find('textarea').textinput('disable');
						that.$el.find('button').button("disable");
					}
				},
				autosavePull:function(){
					// fill radios and checkmarks.
					console.log("save");
					var si = this.model.get("skinInspection");
					_.each(input, function(propertyName,inputName){
						console.log(propertyName +" "+ inputName);
						var val = si[propertyName];
						console.log("radio val");
						if(_.isArray(val ) ){ // checkboxes
//							this.$el.find()
							console.log(val);
							_.each(val, function(arrVal){
								that.$el.find("input[name='"+inputName+"'][value='"+arrVal+"']").prop("checked",true);
							});
						} else { // radio
							that.$el.find("input[name='"+inputName+"'][value='"+val+"']").prop("checked",true);
						}
						console.log(val);

					});
				},
				autosaveEvent:function(){
					console.log("save");
					that.saveAssessment(true);
				},
				saveAssessmentEvent: function(e) {
					e.preventDefault();
					that.savePopup();
					that.saveAssessment();
				},
				saveAssessment: function(doNotSubmit){
					var tempAssessment = this.model.get('skinInspection');
					console.log('saving');
					var shouldSubmit = ! doNotSubmit,
						canSubmit=true,
						riskComplete=false;
					_.every(input,function(val, key) {
						console.log(key + ':' + val);
						var checked = that.$el.find('input[name='+ key + ']:checked'),
							comment = that.$el.find('#'+key+'-comment'),
							field = that.$el.find('#'+key+'-req');

						if (key==='risk-factors-yn')
							field = that.$el.find('#'+'risk-factors'+'-req');

						console.log(comment.val());
						if (comment.val() !== undefined)
							tempAssessment[val+'Comment'] = comment.val();
						if(checked.val()){
							var fallout = false,
								comReq = that.$el.find('#'+key+'-comment-req'),
								tempChecks = [];
							_.each(checked,function(check) {
								var c = $(check);
								tempChecks.push(c.val());
								if (c.val().indexOf('Other') !== -1){
									if (shouldSubmit && comment.html() === '' && comReq.html() === commentReq) {
										canSubmit = false;
										comReq.html(commentReq);
										field.html(' Incomplete');
										fallout=true;
										return false;
									}
								}
							});
							if (key==='assessment')
								tempAssessment[val] = tempChecks.join() === 'true';
							else if (key==='skin-problem' || key==='risk-factors')
								tempAssessment[val] = tempChecks;
							else if (key==='risk-factors-yn' && tempChecks.join()==='No') {
								field.html('');
								riskComplete = true;
								tempAssessment[input['risk-factors']] = undefined;
								tempAssessment[val] = tempChecks.join();
							}
							else
								tempAssessment[val] = tempChecks.join();

							if (fallout)
								return false;

							field.html('');
							return true;
						}
						else {
							canSubmit=false;
							//$(ele).parents('a').click();
							if( shouldSubmit ){
								if (key==='risk-factors' && riskComplete){
									canSubmit = true;
									field.html('');
								}
								else
									field.html(' Incomplete');
							}
						}

						return true;
					});
					if (canSubmit && shouldSubmit)
						tempAssessment.status = "COMPLETE";
					else
						tempAssessment.status = "ACTIVE";
					console.log(tempAssessment);
					this.model.set({
						skinInspection: tempAssessment
					});
					this.model.save({}, {
						success: function () {
							console.log('success');
						},
						fail: function () {
							console.log('failure');
						},
						error: function () {
							console.log('error');
						}
					});
				}
			});
	});